
from gurobipy import Model, GRB

# Create a new model
m = Model("bus_seating")

# Create variables
premium = m.addVar(vtype=GRB.INTEGER, name="premium")
regular = m.addVar(vtype=GRB.INTEGER, name="regular")

# Set objective function
m.setObjective(50 * premium + 30 * regular, GRB.MAXIMIZE)

# Add constraints
m.addConstr(premium + regular <= 100, "capacity")
m.addConstr(premium >= 30, "min_premium")
m.addConstr(regular >= 2 * premium, "regular_preference")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Premium Seats: %g' % premium.x)
    print('Regular Seats: %g' % regular.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

