
from gurobipy import *

# Create a new model
m = Model("Bus_Seating_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="premium_class_seats")
x2 = m.addVar(vtype=GRB.INTEGER, name="regular_class_seats")

# Set objective function: Maximize profit
m.setObjective(50*x1 + 30*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 100, "total_passengers")
m.addConstr(x1 >= 30, "premium_class_minimum")
m.addConstr(x2 >= 2*x1, "regular_class_preferred")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Premium class seats: {x1.x}")
    print(f"Regular class seats: {x2.x}")
    print(f"Maximum profit: ${50*x1.x + 30*x2.x}")
else:
    print("No optimal solution found.")
