
import gurobi

def solve_bus_seating_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name='premium_seats', lb=0, ub=100, vtype=gurobi.GRB.INTEGER)  # Number of premium class seats
    x2 = model.addVar(name='regular_seats', lb=0, ub=100, vtype=gurobi.GRB.INTEGER)  # Number of regular class seats

    # Objective function: Maximize 50*x1 + 30*x2
    model.setObjective(50*x1 + 30*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 100, name='total_passengers')  # Total passengers do not exceed 100
    model.addConstr(x1 >= 30, name='premium_seats_reserved')  # At least 30 premium seats
    model.addConstr(x2 >= 2*x1, name='regular_vs_premium')  # At least twice as many regular as premium

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: {model.x[0].varName} = {model.x[0].x}, {model.x[1].varName} = {model.x[1].x}")
        print(f"Max Profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_bus_seating_problem()
