
import gurobipy as gp

# Create a new model
m = gp.Model("CafeOptimization")

# Create variables
lattes = m.addVar(vtype=gp.GRB.CONTINUOUS, name="lattes")  # Number of lattes
cappuccinos = m.addVar(vtype=gp.GRB.CONTINUOUS, name="cappuccinos")  # Number of cappuccinos


# Set objective function
m.setObjective(2 * lattes + 1 * cappuccinos, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4 * lattes + 2 * cappuccinos <= 80, "MilkConstraint")
m.addConstr(1 * lattes + 2 * cappuccinos <= 50, "CoffeeConstraint")
m.addConstr(lattes >= 0, "NonNegativityLattes")  # Ensure non-negative quantities
m.addConstr(cappuccinos >= 0, "NonNegativityCappuccinos")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of lattes: {lattes.x:.2f}")
    print(f"Number of cappuccinos: {cappuccinos.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

