
from gurobipy import *

# Create a new model
m = Model("Cafe_Optimization")

# Define the variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="lattes", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="cappuccinos", lb=0)

# Set the objective function
m.setObjective(2*x1 + x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x1 + 2*x2 <= 80, "milk_constraint")
m.addConstr(x1 + 2*x2 <= 50, "coffee_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of lattes: {x1.x}")
    print(f"Number of cappuccinos: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
