
import gurobi

def solve_cafe_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='lattes', lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name='cappuccinos', lb=0, ub=gurobi.GRB.INFINITY)

    # Set the objective function
    model.setObjective(2*x1 + x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(4*x1 + 2*x2 <= 80, name='milk_constraint')
    model.addConstr(x1 + 2*x2 <= 50, name='coffee_constraint')

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal number of lattes: {x1.varValue}")
        print(f"Optimal number of cappuccinos: {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("The model is infeasible")

solve_cafe_problem()
