
import gurobipy as gp

# Create a new model
model = gp.Model("Furniture Production")

# Create decision variables
bookcases = model.addVar(vtype=gp.GRB.CONTINUOUS, name="bookcases")  # Number of bookcases
chairs = model.addVar(vtype=gp.GRB.CONTINUOUS, name="chairs")  # Number of garden chairs


# Set objective function: Maximize profit
model.setObjective(270 * bookcases + 350 * chairs, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3 * bookcases + 2 * chairs <= 80, "Woodworking")  # Woodworking constraint
model.addConstr(2 * bookcases + 4 * chairs <= 70, "Nails")  # Nails constraint
model.addConstr(3 * bookcases + 3 * chairs <= 90, "Varnish")  # Varnish constraint
model.addConstr(bookcases >= 0)
model.addConstr(chairs >= 0)


# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Bookcases: {bookcases.x}")
    print(f"Number of Garden Chairs: {chairs.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

