
from gurobipy import *

# Create a new model
m = Model("Nu_Designs_Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="bookcases", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="garden_chairs", lb=0)

# Set the objective function
m.setObjective(270*x1 + 350*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 2*x2 <= 80, "woodworking_hours")
m.addConstr(2*x1 + 4*x2 <= 70, "nails_boxes")
m.addConstr(3*x1 + 3*x2 <= 90, "varnish_units")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Bookcases: {x1.x}")
    print(f"Garden chairs: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
