
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='bookcase', lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name='garden chair', lb=0, ub=gurobi.GRB.INFINITY)

    # Set the objective function
    model.setObjective(270*x1 + 350*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3*x1 + 2*x2 <= 80, name='woodworking')
    model.addConstr(2*x1 + 4*x2 <= 70, name='nails')
    model.addConstr(3*x1 + 3*x2 <= 90, name='varnish')

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Bookcases = {x1.varValue}, Garden Chairs = {x2.varValue}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("The model is infeasible")

solve_optimization_problem()
