
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("umbrella_optimization")

# Create variables
red_umbrellas = m.addVar(vtype=GRB.INTEGER, name="red_umbrellas")
blue_umbrellas = m.addVar(vtype=GRB.INTEGER, name="blue_umbrellas")

# Set objective function
m.setObjective(3 * red_umbrellas + 5 * blue_umbrellas, GRB.MAXIMIZE)

# Add constraints
m.addConstr(red_umbrellas + blue_umbrellas <= 100, "total_umbrellas")
m.addConstr(red_umbrellas >= 10, "min_red_umbrellas")
m.addConstr(blue_umbrellas >= 4 * red_umbrellas, "blue_vs_red")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of red umbrellas: {red_umbrellas.x}")
    print(f"Number of blue umbrellas: {blue_umbrellas.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

