
from gurobipy import *

# Create a new model
m = Model("Souvenir_Shop_Optimization")

# Create variables
x1 = m.addVar(vtype=GRB.INTEGER, name="red_umbrellas", lb=0)
x2 = m.addVar(vtype=GRB.INTEGER, name="blue_umbrellas", lb=0)

# Set the objective function
m.setObjective(3*x1 + 5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 100, "total_umbrellas")
m.addConstr(x1 >= 10, "min_red_umbrellas")
m.addConstr(x2 >= 4*x1, "blue_to_red_ratio")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Red Umbrellas: {x1.x}")
    print(f"Blue Umbrellas: {x2.x}")
    print(f"Total Profit: ${3*x1.x + 5*x2.x}")
else:
    print("No optimal solution found")
