
import gurobi

def solve_umbrella_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="red_umbrellas", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="blue_umbrellas", lb=0, ub=gurobi.GRB.INFINITY)

    # Objective function: maximize 3*x1 + 5*x2
    model.setObjective(3*x1 + 5*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 100, name="total_umbrellas")
    model.addConstr(x1 >= 10, name="min_red_umbrellas")
    model.addConstr(x2 >= 4*x1, name="blue_vs_red")

    # Update model
    model.update()

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: red umbrellas = {x1.varValue}, blue umbrellas = {x2.varValue}")
    else:
        print("No optimal solution found")

solve_umbrella_problem()
