
import gurobipy as gp

# Create a new model
m = gp.Model("basketball_shots")

# Create variables
short_shots = m.addVar(vtype=gp.GRB.INTEGER, name="short_shots")
long_shots = m.addVar(vtype=gp.GRB.INTEGER, name="long_shots")

# Set objective function
m.setObjective(2 * short_shots + 5 * long_shots, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(short_shots + long_shots <= 14, "total_shots")
m.addConstr(short_shots >= 5, "min_short_shots")
m.addConstr(long_shots >= 2, "min_long_shots")
m.addConstr(short_shots <= 8, "max_short_shots")
m.addConstr(long_shots <= 8, "max_long_shots")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal number of short shots: {short_shots.x}")
    print(f"Optimal number of long shots: {long_shots.x}")
    print(f"Maximum score: {m.objVal}")
else:
    print("No solution found.")

