
import gurobi as gp

# Create a new model
m = gp.Model("shot_game")

# Define variables
x1 = m.addVar(lb=5, ub=8, name="short_shots")  # short shots
x2 = m.addVar(lb=2, ub=8, name="long_shots")  # long shots

# Objective function: maximize 2*x1 + 5*x2
m.setObjective(2*x1 + 5*x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(x1 + x2 <= 14, name="total_shots")

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal short shots: {x1.varValue}")
    print(f"Optimal long shots: {x2.varValue}")
    print(f"Maximum score: {2*x1.varValue + 5*x2.varValue}")
else:
    print("The model is infeasible")
