
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Autumn_Auto_Advertising")

# Create variables
talent_show_ads = m.addVar(vtype=GRB.CONTINUOUS, name="talent_show_ads")
global_news_ads = m.addVar(vtype=GRB.CONTINUOUS, name="global_news_ads")


# Set objective function
m.setObjective(80000 * talent_show_ads + 30000 * global_news_ads, GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * talent_show_ads + 13 * global_news_ads >= 50, "baby_boomers_reach")
m.addConstr(20 * talent_show_ads + 7 * global_news_ads >= 30, "millennials_reach")
m.addConstr(talent_show_ads >=0)
m.addConstr(global_news_ads >=0)



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal}")
    print(f"Talent show ads: {talent_show_ads.x}")
    print(f"Global news ads: {global_news_ads.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

