
from gurobipy import *

# Create a new model
m = Model("Autumn_Auto_Advertising")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="talent_show_ads", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="global_news_commercials", lb=0)

# Set the objective function
m.setObjective(80000*x1 + 30000*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x1 + 13*x2 >= 50000000, "baby_boomers")
m.addConstr(20*x1 + 7*x2 >= 30000000, "millennials")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: x1 = {x1.x}, x2 = {x2.x}")
    print(f"Total cost: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
