
import gurobipy as gp

# Create a new model
model = gp.Model("Autumn_Auto_Advertising")

# Define variables
x1 = model.addVar(name="talent_show_ads", lb=0, vtype=gp.GRB.INTEGER)
x2 = model.addVar(name="global_news_ads", lb=0, vtype=gp.GRB.INTEGER)

# Objective function: minimize cost
model.setObjective(80000*x1 + 30000*x2, gp.GRB.MINIMIZE)

# Constraints
model.addConstr(5*x1 + 13*x2 >= 50, name="baby_boomers")
model.addConstr(20*x1 + 7*x2 >= 30, name="millennials")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Talent Show Ads: {x1.varValue}")
    print(f"Global News Ads: {x2.varValue}")
    print(f"Minimum Cost: ${model.objVal:.2f}")
else:
    print("The model is infeasible or unbounded.")
