
import gurobipy as gp

# Create a new model
model = gp.Model("tea_production")

# Create variables
low = model.addVar(vtype=gp.GRB.CONTINUOUS, name="low")  # Low quality tea
medium = model.addVar(vtype=gp.GRB.CONTINUOUS, name="medium") # Medium quality tea
high = model.addVar(vtype=gp.GRB.CONTINUOUS, name="high") # High quality tea


# Set objective function
model.setObjective(1*low + 3*medium + 5*high, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(2*low + 3*medium + 4*high <= 200, "rare_additives")
model.addConstr(6*low + 7*medium + 8*high <= 400, "tea_leaves")
model.addConstr(low >=0)
model.addConstr(medium >= 0)
model.addConstr(high >= 0)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal}")
    print(f"Low quality tea: {low.x}")
    print(f"Medium quality tea: {medium.x}")
    print(f"High quality tea: {high.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

