
from gurobipy import *

# Create a new model
m = Model("TeaProduction")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="low_quality_teas")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="medium_quality_teas")
x3 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="high_quality_teas")

# Set the objective function
m.setObjective(1*x1 + 3*x2 + 5*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x1 + 3*x2 + 4*x3 <= 200, "rare_additives")
m.addConstr(6*x1 + 7*x2 + 8*x3 <= 400, "tea_leaves")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Low-quality teas: {x1.x}")
    print(f"Medium-quality teas: {x2.x}")
    print(f"High-quality teas: {x3.x}")
else:
    print("No optimal solution found")
