
import gurobi

def solve_tea_company_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="low_quality_tea", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="medium_quality_tea", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x3 = model.addVar(name="high_quality_tea", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function
    model.setObjective(1*x1 + 3*x2 + 5*x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2*x1 + 3*x2 + 4*x3 <= 200, name="rare_additives_constraint")
    model.addConstr(6*x1 + 7*x2 + 8*x3 <= 400, name="tea_leaves_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Low quality tea: {x1.varValue}")
        print(f"Medium quality tea: {x2.varValue}")
        print(f"High quality tea: {x3.varValue}")
        print(f"Max profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_tea_company_problem()
