
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("bicycle_optimization")

# Create variables
folding_bikes = m.addVar(vtype=GRB.INTEGER, name="folding_bikes")
touring_bikes = m.addVar(vtype=GRB.INTEGER, name="touring_bikes")

# Set objective function
m.setObjective(200 * folding_bikes + 350 * touring_bikes, GRB.MAXIMIZE)

# Add constraints
m.addConstr(folding_bikes + touring_bikes <= 100, "demand_constraint")
m.addConstr(550 * folding_bikes + 700 * touring_bikes <= 30000, "cost_constraint")
m.addConstr(folding_bikes >= 0, "folding_nonnegativity")
m.addConstr(touring_bikes >= 0, "touring_nonnegativity")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of folding bikes: {folding_bikes.x}")
    print(f"Number of touring bikes: {touring_bikes.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

