
from gurobipy import *

# Create a model
m = Model("Bike_Stocking")

# Define variables
x1 = m.addVar(name='x1', lb=0)  # Number of folding bikes
x2 = m.addVar(name='x2', lb=0)  # Number of touring bikes

# Set the objective function
m.setObjective(200*x1 + 350*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 100, name='total_bikes')
m.addConstr(550*x1 + 700*x2 <= 30000, name='total_value')

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: x1 = {x1.x}, x2 = {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
