
import gurobipy as gp

# Create a new model
model = gp.Model("Bicycle_Problem")

# Define variables
x1 = model.addVar(name="folding_bikes", lb=0, vtype=gp.GRB.INTEGER)  # Number of folding bikes
x2 = model.addVar(name="touring_bikes", lb=0, vtype=gp.GRB.INTEGER)  # Number of touring bikes

# Objective function: Maximize profit
model.setObjective(200*x1 + 350*x2, gp.GRB.MAXIMIZE)

# Demand constraint
model.addConstr(x1 + x2 <= 100, name="demand_constraint")

# Inventory value constraint
model.addConstr(550*x1 + 700*x2 <= 30000, name="inventory_value_constraint")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Max Profit: {model.objVal}")
else:
    print("The model is infeasible.")
