
import gurobi

def solve_grandmother_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="blankets", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="sweaters", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Set the objective function
    model.setObjective(5.50 * x1 + 5 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(30 * x1 + 20 * x2 <= 200, name="yarn_constraint")
    model.addConstr(5 * x1 + 4 * x2 <= 40, name="knitting_constraint")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("The model is infeasible")

solve_grandmother_problem()
