
import gurobipy as gp

# Create a new model
m = gp.Model("bath_store")

# Create variables
rubber_ducks = m.addVar(vtype=gp.GRB.CONTINUOUS, name="rubber_ducks")
toy_boats = m.addVar(vtype=gp.GRB.CONTINUOUS, name="toy_boats")


# Set objective function
m.setObjective(2 * rubber_ducks + 4 * toy_boats, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5 * rubber_ducks + 8 * toy_boats <= 1000, "preparation_time")
m.addConstr(3 * rubber_ducks + 2 * toy_boats <= 700, "testing_time")
m.addConstr(rubber_ducks >= 0, "rubber_ducks_nonnegative")  # Ensure non-negative quantities
m.addConstr(toy_boats >= 0, "toy_boats_nonnegative")  # Ensure non-negative quantities


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of rubber ducks: {rubber_ducks.x:.2f}")
    print(f"Number of toy boats: {toy_boats.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

