
from gurobipy import *

# Create a new model
m = Model("Bath_Store_Profit")

# Add variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="rubber_ducks")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="toy_boats")

# Set the objective function
m.setObjective(2*x1 + 4*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x1 + 8*x2 <= 1000, "preparation_time")
m.addConstr(3*x1 + 2*x2 <= 700, "testing_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Rubber Ducks: {x1.x}")
    print(f"Toy Boats: {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
