
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="rubber_ducks", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="toy_boats", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Maximize 2*x1 + 4*x2
    model.setObjective(2*x1 + 4*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(5*x1 + 8*x2 <= 1000, name="preparation_time")
    model.addConstr(3*x1 + 2*x2 <= 700, name="testing_time")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible")

solve_optimization_problem()
