
import gurobipy as gp

# Create a new model
m = gp.Model("ice_cream_optimization")

# Create variables
cones = m.addVar(vtype=gp.GRB.CONTINUOUS, name="cones")  # Number of ice cream cones
cups = m.addVar(vtype=gp.GRB.CONTINUOUS, name="cups")  # Number of ice cream cups


# Set objective function
m.setObjective(3 * cones + 3.5 * cups, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * cones + 4 * cups <= 500, "scoops_constraint")
m.addConstr(5 * cones + 6 * cups <= 1000, "toppings_constraint")
m.addConstr(cones >= 0, "cones_nonnegativity")  # Ensure non-negative number of cones
m.addConstr(cups >= 0, "cups_nonnegativity")  # Ensure non-negative number of cups


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Revenue: ${m.objVal}")
    print(f"Number of Ice Cream Cones: {cones.x}")
    print(f"Number of Ice Cream Cups: {cups.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

