
from gurobipy import *

# Create a new model
m = Model("Ice Cream Sales")

# Define variables
x1 = m.addVar(name="ice_cream_cones", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="ice_cream_cups", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(3*x1 + 3.5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 4*x2 <= 500, name="ice_cream_scoops")
m.addConstr(5*x1 + 6*x2 <= 1000, name="toppings")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Ice Cream Cones: {x1.x}")
    print(f"Ice Cream Cups: {x2.x}")
    print(f"Total Revenue: {m.objVal}")
else:
    print("No optimal solution found")
