
import gurobi

def solve_ice_cream_truck_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="ice_cream_cones", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="ice_cream_cups", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Maximize 3*x1 + 3.50*x2
    model.setObjective(3*x1 + 3.50*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(3*x1 + 4*x2 <= 500, name="scoops_constraint")
    model.addConstr(5*x1 + 6*x2 <= 1000, name="toppings_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Maximum Revenue: ${model.objVal:.2f}")
    else:
        print("The model is infeasible")

solve_ice_cream_truck_problem()
