
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("toy_production")

# Create variables
trains = m.addVar(vtype=GRB.INTEGER, name="trains")
planes = m.addVar(vtype=GRB.INTEGER, name="planes")

# Set objective function
m.setObjective(50 * trains + 60 * planes, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30 * trains + 40 * planes <= 4000, "woodworker_time")
m.addConstr(planes >= 3 * trains, "plane_demand")
m.addConstr(trains >= 0, "non_negativity_trains")  # Explicit non-negativity constraints
m.addConstr(planes >= 0, "non_negativity_planes")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of trains: {trains.x}")
    print(f"Number of planes: {planes.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

