
from gurobipy import *

# Create a new model
m = Model("Toy Store Optimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="trains")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="planes")

# Set the objective function
m.setObjective(50*x1 + 60*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30*x1 + 40*x2 <= 4000, "time_constraint")
m.addConstr(x2 >= 3*x1, "production_requirement")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of trains: {x1.x}")
    print(f"Number of planes: {x2.x}")
    print(f"Maximum profit: ${50*x1.x + 60*x2.x:.2f}")
else:
    print("No optimal solution found")
