
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="trains", lb=0, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="planes", lb=0, vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(50 * x1 + 60 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(30 * x1 + 40 * x2 <= 4000, name="woodworker_time")
    model.addConstr(x2 >= 3 * x1, name="plane_train_ratio")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal number of trains: {x1.varValue}")
        print(f"Optimal number of planes: {x2.varValue}")
        print(f"Maximal profit: {model.objVal}")
    else:
        print("The model is infeasible")

solve_optimization_problem()
