
import gurobipy as gp

# Create a new model
m = gp.Model("diet_problem")

# Create variables
burgers = m.addVar(vtype=gp.GRB.CONTINUOUS, name="burgers")
fries = m.addVar(vtype=gp.GRB.CONTINUOUS, name="fries")

# Set objective function
m.setObjective(7 * burgers + 3 * fries, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(500 * burgers + 300 * fries >= 3000, "calorie_req")
m.addConstr(30 * burgers + 5 * fries >= 150, "protein_req")
m.addConstr(burgers >= 0, "burgers_nonneg")
m.addConstr(fries >= 0, "fries_nonneg")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Objective value: {m.objVal}")
    print(f"Number of burgers: {burgers.x}")
    print(f"Number of fries: {fries.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

