
from gurobipy import *

# Create a new model
m = Model("Burgers_and_Fries")

# Add variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="burgers", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="fries", lb=0)

# Set the objective function
m.setObjective(7*x1 + 3*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(500*x1 + 300*x2 >= 3000, "calories")
m.addConstr(30*x1 + 5*x2 >= 150, "protein")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of burgers: {x1.x}")
    print(f"Number of orders of fries: {x2.x}")
    print(f"Total cost: {7*x1.x + 3*x2.x}")
else:
    print("No optimal solution found")
