
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='x1', lb=0, vtype=gurobi.GRB.CONTINUOUS)  # Number of burgers
    x2 = model.addVar(name='x2', lb=0, vtype=gurobi.GRB.CONTINUOUS)  # Number of orders of fries

    # Define the objective function
    model.setObjective(7 * x1 + 3 * x2, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(500 * x1 + 300 * x2 >= 3000, name='calorie_requirement')
    model.addConstr(30 * x1 + 5 * x2 >= 150, name='protein_requirement')

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Minimum cost: {model.objVal}")
    else:
        print("The problem is infeasible")

solve_optimization_problem()
