
import gurobipy as gp

# Create a new model
m = gp.Model("investment_optimization")

# Create variables
avocado_investment = m.addVar(name="avocado_investment")
kale_investment = m.addVar(name="kale_investment")

# Set objective function
m.setObjective(0.05 * avocado_investment + 0.08 * kale_investment, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(avocado_investment + kale_investment <= 300000, "total_investment")
m.addConstr(avocado_investment >= 0.3 * 300000, "min_avocado_investment")
m.addConstr(kale_investment <= 0.6 * 300000, "max_kale_investment")
m.addConstr(avocado_investment >= 0, "non_negative_avocado")
m.addConstr(kale_investment >= 0, "non_negative_kale")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal investment in avocado industry: ${avocado_investment.x:.2f}")
    print(f"Optimal investment in kale industry: ${kale_investment.x:.2f}")
    print(f"Maximum return: ${m.objVal:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

