
from gurobipy import *

# Create a new model
m = Model("Investment_Optimization")

# Define variables
x1 = m.addVar(lb=0, name="avocado_investment")
x2 = m.addVar(lb=0, name="kale_investment")

# Set the objective function
m.setObjective(0.05*x1 + 0.08*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 == 300000, "total_investment")
m.addConstr(x1 >= 90000, "min_avocado")
m.addConstr(x2 <= 180000, "max_kale")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Avocado Investment: {x1.x}")
    print(f"Kale Investment: {x2.x}")
    print(f"Total Return: {m.ObjVal}")
else:
    print("No optimal solution found")
