
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, name="avocado_investment")
    x2 = model.addVar(lb=0, name="kale_investment")

    # Objective function: Maximize 0.05*x1 + 0.08*x2
    model.setObjective(0.05*x1 + 0.08*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 300000, name="total_investment")
    model.addConstr(x1 >= 90000, name="min_avocado_investment")
    model.addConstr(x2 <= 180000, name="max_kale_investment")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal investment in avocado industry: $", x1.varValue)
        print("Optimal investment in kale industry: $", x2.varValue)
        print("Maximum return: ", 0.05*x1.varValue + 0.08*x2.varValue)
    else:
        print("The model is infeasible")

solve_investment_problem()
