
import gurobipy as gp

# Create a new model
model = gp.Model("PCB_Production")

# Create variables
small_pcbs = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="small_pcbs")
large_pcbs = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="large_pcbs")


# Set objective function
model.setObjective(20 * small_pcbs + 35 * large_pcbs, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3 * small_pcbs + 5 * large_pcbs <= 250, "silicon_constraint")
model.addConstr(30 * small_pcbs + 40 * large_pcbs <= 800, "design_constraint")
model.addConstr(20 * small_pcbs + 30 * large_pcbs <= 600, "soldering_constraint")
model.addConstr(small_pcbs >= 5, "min_small_pcbs")
model.addConstr(large_pcbs >= 6, "min_large_pcbs")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of small PCBs to produce: {small_pcbs.x}")
    print(f"Number of large PCBs to produce: {large_pcbs.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

