
from gurobipy import *

# Create a new model
m = Model("PCB_Production")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="small_PCBs")
x2 = m.addVar(vtype=GRB.INTEGER, name="large_PCBs")

# Set the objective function
m.setObjective(20*x1 + 35*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(3*x1 + 5*x2 <= 250, "silicon")
m.addConstr(30*x1 + 40*x2 <= 800, "design_time")
m.addConstr(20*x1 + 30*x2 <= 600, "soldering_time")
m.addConstr(x1 >= 5, "min_small_PCBs")
m.addConstr(x2 >= 6, "min_large_PCBs")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Small PCBs: {x1.x}")
    print(f"Large PCBs: {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
