
import gurobi

def solve_pcb_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name='x1', lb=0, vtype=gurobi.GRB.INTEGER)  # small PCB's
    x2 = model.addVar(name='x2', lb=0, vtype=gurobi.GRB.INTEGER)  # large PCB's

    # Objective function: maximize 20*x1 + 35*x2
    model.setObjective(20*x1 + 35*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(3*x1 + 5*x2 <= 250)  # silicon units
    model.addConstr(30*x1 + 40*x2 <= 800)  # design time
    model.addConstr(20*x1 + 30*x2 <= 600)  # soldering time
    model.addConstr(x1 >= 5)  # minimum small PCB's
    model.addConstr(x2 >= 6)  # minimum large PCB's

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Maximum profit: ${20*x1.varValue + 35*x2.varValue}")
    else:
        print("No optimal solution found.")

solve_pcb_problem()
