
import gurobipy as gp

# Create a new model
m = gp.Model("Flower_Profit_Maximization")

# Create decision variables
sunflowers = m.addVar(lb=0, name="sunflowers")  # Acres of sunflowers
roses = m.addVar(lb=0, name="roses")  # Acres of roses

# Set objective function: Maximize profit
m.setObjective(200 * sunflowers + 375 * roses, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(sunflowers + roses <= 40, "Land_Constraint")  # Total land constraint
m.addConstr(5 * sunflowers + 8 * roses <= 230, "Nutrition_Constraint")  # Plant nutrition constraint


# Optimize the model
m.optimize()

# Print the optimal solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution:")
    print(f"  Sunflowers: {sunflowers.x} acres")
    print(f"  Roses: {roses.x} acres")
    print(f"  Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

