
from gurobipy import *

# Create a new model
m = Model("Florist_Problem")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="sunflowers_acres")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="roses_acres")

# Set the objective function
m.setObjective(200*x1 + 375*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 40, "total_acres")
m.addConstr(5*x1 + 8*x2 <= 230, "plant_nutrition")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Sunflowers acres: {x1.x}")
    print(f"Roses acres: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
