
import gurobi

def solve_florist_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="sunflowers")
    x2 = model.addVar(lb=0, name="roses")

    # Set the objective function
    model.setObjective(200 * x1 + 375 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(x1 + x2 <= 40, name="acres_constraint")
    model.addConstr(5 * x1 + 8 * x2 <= 230, name="nutrition_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Acre of sunflowers: {x1.varValue}")
        print(f"Acre of roses: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_florist_problem()
