
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("banana_transport")

# Create variables
cars = m.addVar(vtype=GRB.INTEGER, name="cars")
bikes = m.addVar(vtype=GRB.INTEGER, name="bikes")

# Set objective function
m.setObjective(100 * cars + 30 * bikes, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10 * cars + 6 * bikes <= 200, "budget")
m.addConstr(cars < bikes, "traffic_law")
m.addConstr(cars >= 0, "non_negativity_cars")  # Explicit non-negativity constraints
m.addConstr(bikes >= 0, "non_negativity_bikes")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Number of cars: {cars.x}")
    print(f"  Number of bikes: {bikes.x}")
    print(f"  Number of bananas transported: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

