
from gurobipy import *

# Create a new model
m = Model("banana_transportation")

# Define variables
x = m.addVar(vtype=GRB.INTEGER, name="cars")
y = m.addVar(vtype=GRB.INTEGER, name="motorcycles")

# Set the objective function
m.setObjective(100*x + 30*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x + 6*y <= 200, "cost_constraint")
m.addConstr(x <= y - 1, "traffic_law_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Cars: {x.x}")
    print(f"Motorcycles: {y.x}")
    print(f"Total bananas transported: {100*x.x + 30*y.x}")
else:
    print("No optimal solution found")
