
import gurobi

def solve_transportation_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="cars", lb=0, vtype=gurobi.GRB.INTEGER)  # Number of cars
    x2 = model.addVar(name="bikes", lb=0, vtype=gurobi.GRB.INTEGER)  # Number of bikes

    # Objective function: Maximize 100*x1 + 30*x2
    model.setObjective(100*x1 + 30*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(10*x1 + 6*x2 <= 200, name="cost_constraint")
    model.addConstr(x1 - x2 <= -1, name="vehicle_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Cars: {x1.varValue}")
        print(f"Bikes: {x2.varValue}")
        print(f"Max Bananas: {100*x1.varValue + 30*x2.varValue}")
    else:
        print("The model is infeasible")

solve_transportation_problem()
