
import gurobipy as gp

# Create a new model
m = gp.Model("Software Production")

# Create variables
student_version = m.addVar(vtype=gp.GRB.INTEGER, name="student_version")
professional_version = m.addVar(vtype=gp.GRB.INTEGER, name="professional_version")

# Set objective function
m.setObjective(400 * student_version + 1500 * professional_version, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(student_version + professional_version <= 350, "Total licenses")
m.addConstr(750 * student_version + 3000 * professional_version <= 500000, "Production cost")
m.addConstr(student_version >= 0, "Non-negative student")
m.addConstr(professional_version >= 0, "Non-negative professional")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of student versions: {student_version.x}")
    print(f"Number of professional versions: {professional_version.x}")
    print(f"Maximum profit: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

