
from gurobipy import *

# Create a new model
m = Model("Banana_Software")

# Add variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="student_version", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="professional_version", lb=0)

# Set the objective function
m.setObjective(400*x1 + 1500*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 350, "combined_licenses")
m.addConstr(750*x1 + 3000*x2 <= 500000, "budget")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Student version: {x1.x}")
    print(f"Professional version: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
